IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_TRILHO_PROD_NECESSIDADE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_TRILHO_PROD_NECESSIDADE] 

GO
/****** Object:  StoredProcedure [dbo].[P_TRILHO_PROD_NECESSIDADE]    Script Date: 06/27/2012 18:00:18 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
 
--EXECUTE [P_TRILHO_PROD_NECESSIDADE] 1,1
CREATE PROCEDURE [dbo].[P_TRILHO_PROD_NECESSIDADE] (@CD_EMP INT = 1, @CD_CTR_DEPO INT=1, @CD_MAQ INT=1) 
WITH ENCRYPTION AS

DELETE FROM 
	TRILHO_PROD_NECESSIDADE
WHERE
	CD_EMP = @CD_EMP
	AND CD_CTR_DEPO = @CD_CTR_DEPO;
	
 
INSERT INTO TRILHO_PROD_NECESSIDADE
 (DT_MOV,CD_EMP,CD_CTR_DEPO,CD_FILIAL,CD_PROD,QT_EST,QT_EST_PEND,ESEG,EMAX,MEDIAF,
	NECESSIDADE,QTDE_FACEAMENTO,QTDE_FINANCIADO,QTDE_LIMITADOR,NECESSIDADE_FACEAMENTO,
	NECESSIDADE_FINANCIADO,NECESSIDADE_LIMITADOR )
SELECT 
	DT_MOV = dbo.F_HOJE(),
	p.CD_EMP,
	@CD_CTR_DEPO,
	p.CD_FILIAL, 
	p.CD_PROD,
	p.QT_EST,
	p.QT_EST_PEND,
	EMAX = Round( (dbo.UFD_EST_AJUSTA_EMAX(p.QTDE_FACEAMENTO, GETDATE() + 1, p.QTDE_FINANCIADO, 
										   p.QTDE_LIMITADOR, 
										   (p.MEDIAF/30.00) * (p.EMAX * PERC_ACIMA_EMAX) )),0),	
	ESEG = (dbo.UFD_EST_AJUSTA_EMAX(p.QTDE_FACEAMENTO, GETDATE() + 1, p.QTDE_FINANCIADO, 
										   p.QTDE_LIMITADOR, 
										   (p.MEDIAF/30.00) * p.ESEG)),
	p.MEDIAF,
	round((dbo.UFD_EST_AJUSTA_EMAX(p.QTDE_FACEAMENTO, GETDATE() + 1, p.QTDE_FINANCIADO, 
										   p.QTDE_LIMITADOR, 
										   (p.MEDIAF/30.00) *  (p.EMAX * PERC_ACIMA_EMAX))),0) - (CASE WHEN p.QT_EST_PEND < 0 THEN 
																					0 
																				ELSE 
																					p.QT_EST_PEND
																				END) AS NECESSIDADE,
	p.QTDE_FACEAMENTO,
	p.QTDE_FINANCIADO,
	p.QTDE_LIMITADOR,
	p.QTDE_FACEAMENTO - (CASE WHEN p.QT_EST_PEND < 0 THEN 0 
	ELSE p.QT_EST_PEND
	END) AS NECESSIDADE_FACEAMENTO,
	p.QTDE_FINANCIADO  - (CASE WHEN p.QT_EST_PEND < 0 THEN 0 
	ELSE p.QT_EST_PEND
	END) AS NECESSIDADE_FINANCIADO,	
	ROUND(p.QTDE_LIMITADOR ,0) - (CASE WHEN p.QT_EST_PEND < 0 THEN 0 
	ELSE p.QT_EST_PEND
	END) AS NECESSIDADE_LIMITADOR

FROM
	V_EST_PROD_CPL_ESTOQUE P 
	INNER JOIN V_PRC_FILIAL_DEPOSITO D ON
	P.CD_EMP	= D.CD_EMP AND
	P.CD_FILIAL = D.CD_FILIAL 
	
	INNER JOIN (SELECT 
					CD_EMP, 
					1 + (ISNULL(PERC_ACIMA_EMAX,0)/100.0000) PERC_ACIMA_EMAX
				FROM 
					EST_EXCESSO_MAQ
				WHERE
					CD_EMP=@CD_EMP
					AND CD_EXCESSO_MAQ = @CD_MAQ ) CONFIG ON
	P.CD_EMP= CONFIG.CD_EMP
	 	  
	INNER JOIN (SELECT DISTINCT CD_PROD
					FROM	TRILHO_PROD_EXCESSO E
					WHERE 
						E.CD_EMP  =@CD_EMP
						AND E.DT_MOV    = dbo.F_HOJE() 
						AND E.CD_CTR_DEPO =@CD_CTR_DEPO) E ON 
	P.CD_PROD		= E.CD_PROD
	
WHERE
	P.CD_EMP =@CD_EMP 
	AND D.CD_CTR_DEPO  = @CD_CTR_DEPO
	AND NOT D.FLAG_DEPO = 1
	AND round((dbo.UFD_EST_AJUSTA_EMAX(p.QTDE_FACEAMENTO, GETDATE() + 1, p.QTDE_FINANCIADO, 
										   p.QTDE_LIMITADOR, 
										   (p.MEDIAF/30.00) * (p.EMAX * PERC_ACIMA_EMAX))),0) - (CASE WHEN p.QT_EST_PEND < 0 THEN 
																					0 
																				ELSE 
																					p.QT_EST_PEND
																				END) > 0
	AND STS_PROD_FILIAL = 0
	AND STS_PROD = 0
 


GO


